% Copyright 2021, Hans-Peter Schröcker, <hans-peter.schroecker@uibk.ac.at>,
% https://geometrie.uibk.ac.at/schroecker/
%
% This program is free software: you can redistribute it and/or modify it under
% the terms of the GNU General Public License as published by the Free Software
% Foundation, either version 3 of the License, or (at your option) any later
% version.

% This program is distributed in the hope that it will be useful, but WITHOUT ANY
% WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
% PARTICULAR PURPOSE. See the GNU General Public License for more details.

% You should have received a copy of the GNU General Public License along with
% this program. If not, see <http://www.gnu.org/licenses/>.

%% jgg.cls
\NeedsTeXFormat{LaTeX2e}\relax
\ProvidesClass{jgg}%
[2021/01/07, version 0.01; Style to typeset articles for the Journal for
Geometry and Graphics ]

%%% Load base class with appropriate options.
\LoadClass[paper=letter,twoside,12pt,usegeometry=true]{scrartcl}

%% Setup class options.
\RequirePackage{kvoptions}
\SetupKeyvalOptions{family=JGG, prefix=JGG@}

%%% Option `online' should be set to true for typesetting individual articles
%%% for online publication.
\DeclareBoolOption[true]{online}

%%% Option `volume' should be set to true for typesetting complete volumes, as
%%% opposed to individual articles.
\DeclareBoolOption[false]{volume}

%%% Option `showpagenumbers' should be set to true if pagenumbers are to be
%%% displayed.
\DeclareBoolOption[true]{showpagenumbers}

\ProcessKeyvalOptions*

%%% Set boolean values according to class options
\RequirePackage{xifthen}
\newboolean{isOnline}
\ifJGG@online
  \setboolean{isOnline}{true}
\else
  \setboolean{isOnline}{false}
\fi
\newboolean{isVolume}
\ifJGG@volume
  \setboolean{isVolume}{true}
\else
  \setboolean{isVolume}{false}
\fi
\newboolean{showPageNumbers}
\ifJGG@showpagenumbers
  \setboolean{showPageNumbers}{true}
\else
  \setboolean{showPageNumbers}{false}
\fi

%%% Options for typeset article.
\gdef\JGG@Volume{---}
\gdef\JGG@Year{\the\year}
\gdef\JGG@Number{---}
\gdef\JGG@Startpage{1}    % omit pagenumbers if this is -1
\newcommand{\jggvolume}[1]{\gdef\JGG@Volume{#1}}
\newcommand{\jggyear}[1]{\gdef\JGG@Year{#1}}
\newcommand{\jggnumber}[1]{\gdef\JGG@Number{#1}}
\newcommand{\jggstartpage}[1]{\gdef\JGG@Startpage{#1}\setcounter{page}{\JGG@Startpage}}
\AtBeginDocument{\gdef\JGG@Endpage{\ifthenelse{\equal{\JGG@Startpage}{0}}{0}{%
      \@ifundefined{r@JGGReceivedPage}{\pageref{LastPage}}{\pageref{JGGReceivedPage}}}}}

%%% Set headers and footers
\RequirePackage{scrlayer-scrpage}
\newcommand*{\JGG@Shortauthor}{\@author}%
\newcommand*{\JGG@Shorttitle}{\@title}%
\newcommand{\shortauthor}[1]{\gdef\JGG@Shortauthor{#1}%
  \ifthenelse{\boolean{isOnline}}{\hypersetup{pdfauthor={#1}}}{}
}
\newcommand{\shorttitle}[1]{\gdef\JGG@Shorttitle{#1}}
\AtBeginDocument{%
  \ifthenelse{\boolean{isVolume}}{%
    \pagestyle{scrheadings}
    \ohead[\href{https://isgg.net/jgg/}{Journal for Geometry and Graphics}\\Volume \JGG@Volume{} (\JGG@Year), No.~\JGG@Number%
    \ifthenelse{\boolean{showPageNumbers}}{, \JGG@Startpage--\JGG@Endpage}{, \JGG@Startpage--\JGG@Endpage\\(Page numbers are subject to change.)}%
    \vspace*{-27.6mm}]{}
    \chead{\JGG@Shortauthor: \JGG@Shorttitle}
    \ifoot[\vspace*{-38.0mm}\par ISSN 1433-8157/\$ 2.50 \textcopyright{} \JGG@Year{} Heldermann Verlag]{}
    \ofoot[]{}
    \ohead{\normalsize\pagemark}
  }{%
    % ensure proper page numbers
    % set headlines and footlines
    \pagestyle{scrheadings}
    \chead{\JGG@Shortauthor: \JGG@Shorttitle}
    \ohead[\href{https://isgg.net/jgg/}{Journal for Geometry and Graphics}\\Volume \JGG@Volume{} (\JGG@Year), No.~\JGG@Number%
    \ifthenelse{\boolean{showPageNumbers}}{, \JGG@Startpage--\JGG@Endpage}{, \JGG@Startpage--\JGG@Endpage\\(Page numbers are subject to change.)}%
    \vspace*{-27.6mm}]{}
    \ifoot[\vspace*{-38.0mm}\par ISSN 1433-8157/\$ 2.50 \textcopyright{} \JGG@Year{} Heldermann Verlag]{}
    \ofoot[]{}
    \ohead{\normalsize\pagemark}
  }
}

%%% Load some required or useful packages.
\RequirePackage{lmodern}
\RequirePackage{graphicx}
\RequirePackage{lastpage}
\RequirePackage{enumitem}
\setlist{nosep}

%%% Page and paragraph geometry
\RequirePackage[%
  letterpaper,%
  twoside,%
  inner=25.6mm,outer=23.6mm,%
  bottom=19.6mm,top=17.9mm,%
  headsep=2.7mm,%
]{geometry}
\setlength{\parindent}{1.68em}

%%% Set fonts
\setkomafont{title}{\bfseries\upshape}
\setkomafont{sectioning}{\bfseries}
\addtokomafont{section}{\large}
\setkomafont{descriptionlabel}{\bfseries\upshape}
\setkomafont{pageheadfoot}{\normalfont\small}
\setkomafont{caption}{\small}

\RequirePackage{amsmath,amsthm,amsfonts}

%%% Title page
\newcommand*{\JGG@Affiliation}{}%
\newcommand{\affiliation}[1]{\gdef\JGG@Affiliation{#1}}
\renewcommand*{\@maketitle}{%
  \vspace*{16.7mm}
  \begin{center}%
    {\normalfont\bfseries\LARGE
      \@title\par}%
    \vspace*{7.50mm}
    {\begin{tabular}[t]{c}
        % \large
        \bfseries
        \parbox{\linewidth}{\centering\@author}%
      \end{tabular}\par
    }%
    \vspace*{0.0mm}
    {\begin{center}
        % \large
        \JGG@Affiliation
      \end{center}\par
    }%
  \end{center}%
  \enlargethispage{-9mm}% make first page smaller in order to make space for the
                        % Heldermann line.
}%
\gdef\authorseperator{}
\newcommand{\addauthor}[2][]{\ignorespaces\authorseperator#2\textsuperscript{#1}\gdef\authorseperator{, {}}\ignorespaces}
\newcommand{\addaddress}[3][]{{\itshape\textsuperscript{#1}#2}\\\texttt{\small#3}\par\medskip}

%%% Keywords
\newcommand*{\JGG@Keywords}{}%
\newcommand{\keywords}[1]{\gdef\JGG@Keywords{#1}%
  \ifthenelse{\boolean{isOnline}}{\hypersetup{pdfkeywords={#1}}}{}}

%%% MSC
\newcommand*{\JGG@MSC}{}
\newcommand{\MSC}[2][]{%
  \ifthenelse{\isempty{#1}}{\gdef\JGG@MSC{#2}}{\gdef\JGG@MSC{#1 (primary), #2}}
}

%%% Abstract
\renewenvironment{abstract}%
    {\vspace*{2.65mm}\begin{quotation}\noindent\textbf{Abstract.}}%
    {
      \ifthenelse{\equal{\JGG@Keywords}{}}{}{\\[1mm]{\em Key Words:} \JGG@Keywords}
      \ifthenelse{\equal{\JGG@MSC}{}}{}{\\[1mm]{\em MSC 2020:} \JGG@MSC}
    \end{quotation}}

%%% Some useful commands for typesetting the list of references (also when using
%%% bibtex).
\providecommand{\doi}[1]{doi: \texttt{#1}}
\providecommand{\arxiv}[1]{arXiv: \texttt{#1}}
\providecommand{\URL}[1]{\url{#1}}
\renewcommand{\URL}[1]{\url{#1}}
\providecommand{\urlprefix}{URL }
\renewcommand{\urlprefix}{}
\RequirePackage{xurl}

%%% Things to be done differently for online version:
\ifthenelse{\boolean{isOnline}}{%
  \RequirePackage[pdfusetitle]{hyperref}
  \hypersetup{
    pdfsubject={Article published in the Journal for Geometry and Graphics <https://isgg.net/jgg/>},%
    pdfborder={0 0 0},%
    colorlinks=false,%
  }
  \renewcommand{\doi}[1]{\href{https://dx.doi.org/#1}{{\normalfont doi:} \texttt{#1}}}
  \renewcommand{\arxiv}[1]{\href{https://arxiv.org/abs/#1}{\normalfont{arXiv:} \texttt{#1}}}
  %\renewcommand{\URL}[1]{\url{#1}}
}{
  \providecommand{\href}[2]{#2}
  \RequirePackage{url}
}

% A useful package for bibliographic references. It is compatible with jgg.bst.
\RequirePackage[numbers,sort&compress]{natbib}

% Commands for printing date range of reviewing.
\newcommand*{\JGG@Received}{}%
\newcommand{\received}[1]{\gdef\JGG@Received{#1}}
\newcommand*{\JGG@FinalForm}{}%
\newcommand{\finalform}[1]{\gdef\JGG@FinalForm{#1}}
\newcommand{\jggreceived}{\par\bigskip\noindent Received\label{JGGReceivedPage}
  \JGG@Received; final form \JGG@FinalForm.}
